<?php

// Wewntrz funkcji array_map() wykorzystujemy zwrotne wywoanie metody obiektu.
// Kady element tablicy $untidy_array przekazywany jest do metody $parser->tidy(),
// a zwrcone wartoci zapisywane s do tablicy $tidied_array
$tidied_array = array_map(array($parser, 'tidy'), $untidy_array);

// Wewntrz funkcji array_map() wykorzystujemy zwrotne wywoanie metody statycznej.
// Kady element tablicy $untidy_array przekazywany jest do metody Parser::tidy(),
// a zwrcone wartoci zapisywane s do tablicy $tidied_array
$tidied_array = array_map(array('Parser', 'tidy'), $untidy_array);
class Parser
{
// Przykadowa metoda usuwajca z wiersza kocowe znaki biae
// komentarze rozpoczynajce si od znaku '#'
// (takie jak w arkuszach stylw).
static function strip_comments($element)
{
    $element = preg_replace('/#[^#]*$/', '', $element);
    $element = rtrim($element);
    return $element;
}
}

$shell_script = file('foo.sh');
$tidied_script = array_map(array('Parser', 'strip_comments'), $shell_script);


// W ramach wywoa zwrotnych obiekt moe korzysta ze swoich wasnych metod 
// zarwno w przekazywanych my parametrach, jak i w swoich wasnych waciwociach.
$tidied_code = array_map(array($this, 'tidy'), $this->code_array);

// W ramach danej klasy, metody klas rwnie mog by wykorzystywane jako wywoania zwrotne.
$tidied_code = array_map(array('self', 'tidy'), $code_array);

?>
